 /*------------------------------------------------------------------------------*
 * File Name: NFTFO.h -> FunctionOrganizer.h -> FunctionGroup.h					*
 * Creation: Frank	 															*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Frank v8.0861	4/23/04				ADD_PARAMETER_TO_STORE_DELECT_FUNCT_INDEX*
 * Frank v8.0872	5/17/04				ADD_DIALOG_ASKER_USER_RENAME_FUNCION_FILE*
 * Frank v8.0878	5/26/04				CHECK_AND_INIT_FUNCTION_TREE			*
 * Frank v8.0878	5/26/04 QA70-6086	REMOVE_TEMPFILE_AFTER_CLOSED_WITHOUT_SAVE*
 * Frank v8.0878 	5/27/04	QA70-6418	SHARE_FUNCIONT_IN_FUNCIOTNORGANIZER		*
 * Frank v8.0879 	5/27/04 QA70-6418	READ_SHARE_FUNCTION_FROM_ALL_USER_FOLDER*
 * Frank v8.0881	6/2/04	QA70-6086	REMOVE_FDF_FILE_SAVE_INTERCHANGE_SHARE	*
 * Frank V8.0881	6/2/04	QA70-6086	ADD_SOURCE_IN_NEW_FUNCTION_TREE			*
 * Frank v8.0890	6/16/04 QA70-6086	LOAD_SIMULATE_DEFAULT_SETTING			*
 * Frank v8.0890	6/17/04 QA70-6086	SAVE_ABSOLUTE_PATH_OF_SHARE_FUNCTION	*
 * Frank v8.0890	6/17/04	QA70-6086	ADD_FEATURE_ATTRIBUTER_TO_DUPLI_FUNCTION*
 * Frank v8.0104	7/28/04	QA70-6086	UPDATE_CATEGORY_NLSF					*
 * Frank v8.0108	8/2/04	QA70-6086	ADD_FUNCTION_CHECK_ZERO_COUNT_AND_RENAME*
 * Frank v8.0108	8/2/04	QA70-6086	ADD_FUNCTION_REMOVE_SHARE_INFORE		*
 * Frank v8.0110	8/4/04	QA70-6086	REMOVE_FUNCTION_INIT_PART_CREATED		*
 * Frank v8.0147	10/14/04			CENTRALIZE_FO_FUNCTION_TO_TREE_UTLIS	*
 * Frank v8.0162c	11/13/04			CLEAN_CODE_OF_FO						*
 * Danice 11/15/04 v8.0162 FIXED_CODING_BUG										*
 * Frank v8.0168b	12/01/04			FIXED_DUPLIATE_PROBLEM					*
 * Frank v8.0169	12/04/04			FIXED_NAMING_SHARE_PREVIEW_BUG			*
 * Frank  12/16/04 v8.0173 FO_CODE_CLEANING										*
 * DG 12/29/04 v8.0180 CLEAN_UP_DUPLICATE										*
 * DG 12/31/04 v8.0180 NEW_MECHANISM_FOR_FUNCTION_LOAD							*
 *	CPY 1/6/04 v8.0183 NLFIT_NOT_WORKING_NEED_CLEAN_UP							*
 *	CPY 1/10/04 v8.0183 NLF_FILE_PATH_CLEANUP									*
 *  Iris 01/18/05 CENTRALIZE_FUNCTION_NAME_CODES								*
 *  DG 1/18/05 v8.0184 QA70-7331 SUPPORT_X_FUNCTION								*
 *	DSC 2/2/05 v8/0189 CENTRALIZE_PATH_PREFIX_CODES								*
 *	DSC 2/7/05 v8.0190 MOVED_CONSTANTS_TO_FUNC_ORG_H							*
 *	CPY 2/7/05 v8.0189 SET_TREE_NODE_VALUE										*
 *	DSC 2/8/05 v8.0189 DELETE_NODE_NAME_CONSTANTS								*
 *	DSC 2/8/05 Changed name from FunctionOrganizer.h to FunctionGroup.h			*
 *  DG 2/16/05 CENTRALIZE_XFO_AND_NFO											*
 *	YuI 2/17/05 XYDATARANGE_PROPERTY_IMPLEMENTATION								*
 *  DG 3/3/05 v8.0198 INI_FILE_CLEAN_UP											*
 *  DG 3/9/05 v8.0201 DISABLE_GUI_INTERFACE_IN_FO								*
 *	YuI 03/22/05 LOW_LEVEL_FUNCTION_TO_CHECK_RANGE_REALITY						*
 *	ML 3/24/2005 CONTEXT_MENU_X_FUNCS											*
 *  DG 3/25/05 v8.0210 FUNCTION_ONLY_LOAD_ITS_EXT_FILE							*
 * DG 3/30/05 v8.0212 CLEAN_DUPLICATE_MORE										*
 * DG 4/7/05 v8.0217 VC_FUNCTION_SUPPORT										*
 *  DG 6/7/06 QA70-7785 v8.0246 WEB_XF_SUPPORTED								*
 *  DG 7/1/05 QA70-7785 v8.0261 CHECK_FOR_UPDATE								*
 *	Jasmine 10/30/06 CHANGE_FIND_FILE_MECHANISM_TO_NLFIT						*
 *	Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE								*
 *	Cheney 2007-5-9 CLEAN_UP_CODE_FOR_NUMFUNC_LOAD								*
 *	Jasmine 06/11/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT				*
 *	Jasmine 07/08/08 QA80-9434 DEFINE_PEAK_FUNC_IN_FO							*
 *	Sophy 11/6/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE				*
 *	Kyle 01/13/2009 v8.0995d SHOW_ERROR_MESSAGE_WHEN_THE_FILE_WITH_THE_SAME_NAME_EXISTS
 *	Kyle 03/24/2009 QA80-13291-P4 ADD_NEW_TAB_TO_SHOW_REFERENCES_INFORMATION	*
 *	Kyle 03/26/2009 QA80-13291-P4 NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION		*
 *	Kenny 11/12/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES		*
 *	Jasmine 05/13/10 ORG-2 MOVE_FUNCTION_TO_BASE_CLASS_FOR_FITFUNCWIZ			*
 *	Folger 06/24/10 ORG-390-P3 FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
 *	Folger 07/13/10 ORG-543 PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
 *------------------------------------------------------------------------------*/

//#pragma PCH //CPY 1/6/04 v8.0183 NLFIT_NOT_WORKING_NEED_CLEAN_UP

#ifndef _FO_H_
#define _FO_H_

#include <Array.h>

//#define STR_OLDFILENAME_ATTRIB			"OldName"	///Jasmine 06/13/07 MAKE_CONNECTION_BETWEEN_SAME_FUNCTION, move to nlsf_util

enum { ID_FIT_FUNCTION, ID_X_FUNCTION, ID_WEB_XF }; ///DG WEB_XF_SUPPORTED

#define STR_ERROR_NOT_EMPTY_NAME 			_L("Name can not be empty!")
#define STR_ERROR_NAME_EXIST				_L("Name already exist!")
#define STR_ERROR_SYS_FUNCTION				_L("System function name can't be changed.")
#define STR_ERROR_SYS_FUNC_UNEDITABLE		_L("This System function is not editable.\nYou can use the same user function.")
#define STR_ERROR_GET_DETAIL_FAIL			_L("Failed to get detail!")
#define STR_ERROR_FUNCTION_FILE_EXIST		_L("File name has already been used!")
#define STR_ERROR_INVALID_NAME 				_L("Invalid name.")
#define STR_ERROR_CORRECT_NAME 				_L("Invalid name has been auto corrected.");

#define STR_NODE_FUNCTION					"Function"
#define STR_NODE_CATEGORY					"Category"
#define STR_NEW_FUNCTION_PREFIX				"NewFunction"
#define STR_NEW_CATEGORY_PREFIX				"NewCategory"
#define STR_DUPLICATE_PREFIX				"CopyOf"

	
class FunctionOrganizer
{
public :
	FunctionOrganizer()
	{
		///------ Folger 07/13/10 ORG-543 PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
		m_hwndOwner = NULL;
		///------ End PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
	}
	~FunctionOrganizer() {;}
	
	///Kyle 03/26/2009 QA80-13291-P4 NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION
	/////Kyle 03/24/2009 QA80-13291-P4 ADD_NEW_TAB_TO_SHOW_REFERENCES_INFORMATION
	//string 				GetReferencesInfo(const TreeNode& tr);
	/////End ADD_NEW_TAB_TO_SHOW_REFERENCES_INFORMATION
	TreeNode 	GetReferences(const TreeNode& tr, bool bAddWhenNoExist=true);
	void		SetReferences(TreeNode& tr, string strRefInfo, bool bAddWhenNoExist = true);
	///End NEW_EDIT_BOX_FOR_REFERENCES_INFORMATION
	
	///DG CHECK_FOR_UPDATE
	virtual bool	IsCheckForUpdatedSupported() { return false; }
	///end CHECK_FOR_UPDATE
	
	virtual string	GetFuncFileName(const TreeNode& trFunction, bool bGetFullPath = false, int* pType = NULL);
	virtual void	SetFuncFileName(TreeNode& trFunction, LPCSTR lpcszFileName, bool bFullPathGiven = true);
	
	string 			GetLabel(const TreeNode& tr);
	void 			SetLabel(TreeNode& tr, string strLabel);	
	
	///DG 4/4/05
	virtual bool		IsAllowedMultiLevelCategory() { return true; }
	virtual bool		IsDetailTreeView() { return true; }
	virtual bool		IsAllowSimulation() {return false;}	///DG 8/17/05 CLOSE_FO_SIMULATION_FOR_XF
	virtual bool		ConstructFunctionDetail(const TreeNode &trGUI, TreeNode &trFunctionDetail, string* pstrErr = NULL) {return false;}	///DG 8/17/05
	///end
	virtual int			GetMultiOpenBox(vector<string>& vsFilePaths, LPCSTR lpcszPath=NULL) {return -1;}
	virtual string		GetFunctionFolder(int nPath=SYS_FOLDER, string strSubFolder="") {return "";}
	virtual string		GetFunctionFileFullPath(string strFileName, int nPath=SYS_FOLDER, string strSubFolder="") {return "";}
	virtual string		GetFuncFilePath(TreeNode tr, int nPath=USER_FOLDER) {return "";}
	virtual string		GetFunctionName(LPCSTR lpcstrFile){ return "";}	///Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE
	virtual string		GetFunctionName(TreeNode tr, bool bIncludePrefix=false) { return "";}
	virtual void		SetFunctionName(TreeNode &trFunction, string strName, const int *pnPath=NULL) {;}
	virtual int			FindCategoryPath(const TreeNode &trCagetory, vector<int> &vnExistPathType) {return -1; }	///DG 3/3/05
	
	virtual bool		New(TreeNode &trFunction, string strName="") {return false;}
	///Cheney 2007-5-9 CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
	//virtual bool		Load(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, string strName="") {return false;}
	virtual bool		Load(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, LPCSTR lpcszFunctionName = NULL, bool bLoadFDF = true) {return false;}
	///end CLEAN_UP_CODE_FOR_NUMFUNC_LOAD
	virtual bool		Add(TreeNode &trFunction, LPCSTR lpcszFullpathFilename, string strName="") {return false;} ///DG 2/23/05 : add function into function list(and folder)
	virtual bool 		Delete(TreeNode &trFunction, bool bRemoveFile = true) {return false;}
	virtual bool		Duplicate(TreeNode &trFunction, TreeNode trSource, string strName="") {return false;}
	///Sophy 11/6/08 QA80-12442 SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE 
	//virtual bool	 	Save(TreeNode &trFunction, LPCSTR lpcszFullpathFilename = NULL) {return false;}
	virtual bool	 	Save(TreeNode &trFunction, LPCSTR lpcszFullpathFilename = NULL, string* pstrErr = NULL ) {return false;}
	///end SHOW_WARNING_WHEN_SAVE_READ_ONLY_FILE
	//virtual bool		SaveToCategory(TreeNode &trFunction, LPCSTR lpcszCategory) {return false;}
	
	virtual bool		NewCategory(TreeNode &trCategory, string strName="") {return false;}
	virtual int			LoadCategory(TreeNode &trCategory, vector<int> &vnInvalidFunctionIndex) {return false;}
	virtual bool 		DeleteCategory(TreeNode &trCategory, bool bRemoveFile = true) {return false;}
	virtual bool		DuplCategory(TreeNode &trCategory, TreeNode trSource, string strName="") {return false;}
	virtual bool		SaveCategoryName(TreeNode &trCategory, string strName) {return false;}
	//virtual bool		SaveCategory(TreeNode &trCategory, vector<string> &vsSaveFail) {return false;}
	
	virtual bool		SaveSimulateTree(TreeNode trFunction) {return false;} //DG 5/12/05
	
	bool				SaveCategory(TreeNode &trCategory, vector<string> &vsSaveFail); //DG 2/24/05
	///Jasmine 06/11/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	virtual bool				Reset(TreeNode &trFunction){return false;}
	virtual bool				ResetCategory(TreeNode &trCategory){return false;}
	///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	///DG VC_FUNCTION_SUPPORT : later we will support getcategorylist for fit function, than this function should be virtual
	//virtual int			GetCategoryList(TreeNode &trCategoryList, bool bGetFunctionList = true) {return -1;}	///DG 4/7/05 use new vc function to get list
	virtual int			GetSupportFile(){ return SUPPORTFILE_UNDEF; }
	virtual int			GetCategoryList(TreeNode &trCategoryList, bool bGetFunctionList = true);
	///end VC_FUNCTION_SUPPORT
	virtual int 		GetFunctionList(TreeNode &trCategory){return 0;}///Jasmine 10/30/06 CHANGE_FIND_FILE_MECHANISM_TO_NLFIT
	void				SetDisplayIcon(TreeNode &tr, int nResID=-1);
	virtual bool		CheckFileNameExist(string strFileName, const string strCheckInFolder) {return false;}
	
	bool				IsFunction(TreeNode tr);	///DG 2/25/05
	bool				IsSysFunction(TreeNode tr);	///DG 3/3/05
	bool				IsSharedFunction(TreeNode tr);///Jasmine 10/08/07 CANNOT_REMOVE_SHARED_FUNCTION
	int					GetSimulateType(TreeNode tr);///Jasmine 07/09/07 v8.0655 CHECK_INDEPENDENT_VARIABLE_NUMBER_TO_OPEN_SIMCURVE
	void				MarkChanged(TreeNode &tr, string *pstrVal=NULL);
	bool				CheckChanged(TreeNode &tr, string *pstrVal=NULL);
	void				ClearChanged(TreeNode &tr);
	TreeNode		 	GetNodeCheckAdd(const TreeNode& tr, LPCSTR lpcszNode, bool bAddWhenNoExist=true, string strSubNode="");
	
	string				GetFunctionNameStr(const string strName, int nFuncFolder=SYS_FOLDER);
	
	virtual bool		DisableGUIInterface(TreeNode &trFunction, bool bRollBack=false) {return false;} ///DG DISABLE_GUI_INTERFACE_IN_FO
	void				DisableGUIInterface(bool bDisable=true) { m_bDisableInterface=bDisable; }
	
	virtual bool		OnAfterValueChange(TreeNode &trRow, TreeNode &trFunction, int nRow, bool *pUndo=NULL, string *pStrError=NULL)
	{
		if(NULL != pUndo)
			*pUndo=true;
		if(NULL != pStrError)
			*pStrError="Not overloading OnAfterValueChange() found";
		return true;
	}
	virtual int			OnShowMenu(TreeNode &trRow, TreeNode &trFunction, int nx, int ny, HWND hWndParent, int nRow, bool bFODlg=true) { return -1; }
	virtual bool		IsCategory(TreeNode tr) {return !IsFunction(tr);}
	
	///DG WEB_XF_SUPPORTED
	virtual bool		IsReadOnlyFunction() { return false; }
	///end WEB_XF_SUPPORTED
	///Jasmine 06/11/07 INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	virtual void 		SetChangedFDFTree(TreeNode& trFDFs){;}	
	virtual	void 		ClearChangedFDFTree(LPCSTR lpcszFunctionName){;}
	///End INTERACTIVE_CHANGE_SAVING_BETWEEN_FO_AND_NLFIT
	bool				IsUnEditableSysFunction(TreeNode trFunction);
	bool 				UpdateFileName(TreeNode &trName, TreeNode &trFunction, string *pStrError=NULL);
	bool 				UpdateCateName(TreeNode &trName, TreeNode &trCategory, string *pStrError=NULL);
	///------ Folger 06/24/10 ORG-390-P3 FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
	//bool 				UpdateFuncName(TreeNode &trName, TreeNode &trFunction, string *pStrError=NULL);
	bool 				UpdateFuncName(TreeNode &trName, TreeNode &trFunction, string *pStrError=NULL, string* pstrFile = NULL);
	///------ End FDF_FILE_NAME_SHOULD_UPDATE_AFTER_FUNCTION_NAME_CHANGED
	/// Kenny 11/12/2009 QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
// 	bool				CheckFuncName(string& strFileName, TreeNode trFunction, string *pStrError=NULL, LPCSTR lpcstrFile = NULL, bool bCheckParentOnly = false);///Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE
// 	///Kyle 01/13/2009 v8.0995d SHOW_ERROR_MESSAGE_WHEN_THE_FILE_WITH_THE_SAME_NAME_EXISTS
// 	bool				CheckFuncName(TreeNode& trFileName, TreeNode trFunction, string *pStrError=NULL, LPCSTR lpcstrFile = NULL, bool bCheckParentOnly = false);
// 	///End SHOW_ERROR_MESSAGE_WHEN_THE_FILE_WITH_THE_SAME_NAME_EXISTS
	enum
	{
		FO_NAME_CHECKING_RETURN_ON_INVALID	= 0x01,
	};
	bool				CheckFuncName(string& strFileName, TreeNode trParent, string *pStrError=NULL, LPCSTR lpcstrFile = NULL, bool bCheckParentOnly = false, DWORD dwCtrl = 0);
	
	bool				CheckFuncName(TreeNode& trFileName, TreeNode trParent, string *pStrError=NULL, LPCSTR lpcstrFile = NULL, bool bCheckParentOnly = false, DWORD dwCtrl = 0);

	bool				CheckCateName(string& strCateName, TreeNode trParent, string *pStrError = NULL);
	/// End QA81-14624 SUPPORT_DRAG_AND_DROP_MULTIPLE_ORIGIN_FILES
	///Jasmine 05/13/10 ORG-2 MOVE_FUNCTION_TO_BASE_CLASS_FOR_FITFUNCWIZ
	virtual string 	CreateNewFunctionName(TreeNode &trFitFunctions, string strAttribute, string strPrefix, string strPostfix){ASSERT(0); return "";}
	///End MOVE_FUNCTION_TO_BASE_CLASS_FOR_FITFUNCWIZ

	///------ Folger 07/13/10 ORG-543 PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
	void				SetOwnerHwnd(HWND hwnd)		{ m_hwndOwner = hwnd; }
	///------ End PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO

	///Jasmine 07/14/10 ORG-486-S1 CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
	virtual bool 		CheckCopyPeakAttributeNodes(bool bPeakFunction, const TreeNode& trSource, TreeNode& trTarget){ASSERT(0); return false;}
	///End CENTRALIZE_PEAK_ATTRIB_TO_NLFIT
private:
	///Kyle 01/13/2009 v8.0995d SHOW_ERROR_MESSAGE_WHEN_THE_FILE_WITH_THE_SAME_NAME_EXISTS
	//bool 				checkFileName(string& strFuncName, TreeNode &trFunction, string *pStrError=NULL);
	//bool				checkCateName(string& strCateName, TreeNode &trCategory, string *pStrError=NULL);
	//bool				isNameEmptyOrExist(string strName, bool bFunctionName, TreeNode &tr, string *pStrError=NULL, LPCSTR lpcstrFile = NULL, bool bCheckParentOnly = false);///Jasmine 11/02/06 FUNC_AND_FILE_NAME_ONE_TO_ONE
	bool 				checkFileName(TreeNode& trFuncName, TreeNode &trFunction, string *pStrError=NULL);
	bool				checkCateName(TreeNode& trCateName, TreeNode &trParent, string *pStrError=NULL);
	bool				isNameEmptyOrExist(TreeNode& trName, bool bFunctionName, TreeNode &tr, string *pStrError=NULL, LPCSTR lpcstrFile = NULL, bool bCheckParentOnly = false);
	///End SHOW_ERROR_MESSAGE_WHEN_THE_FILE_WITH_THE_SAME_NAME_EXISTS
	
protected:
	bool				IsDisableGUIInterface() { return m_bDisableInterface; }
	virtual TreeNode	LoadCategoryStructure(TreeNode &trCategory) { TreeNode trJunk; return trJunk; }	///DG 4/7/05

	///------ Folger 07/13/10 ORG-543 PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
	HWND				GetOwnerHwnd()			{ return m_hwndOwner; }
	///------ End PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
private:
	bool				m_bDisableInterface;
	///------ Folger 07/13/10 ORG-543 PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
	HWND				m_hwndOwner;
	///------ End PROMPT_USER_FOR_WHETHER_COPY_FDF_TO_UFF_WHEN_ADD_IN_FO
};

#endif //_FO_H_
